/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.item;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.SoundInit;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlackstoneGolemArm
extends Item {
    public BlackstoneGolemArm(Item.Properties settings) {
        super(settings);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add((Component)Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                tooltip.remove(Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
                tooltip.add((Component)Component.m_237115_((String)"item.adventurez.blackstone_golem_arm.tooltip"));
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        CompoundTag tags = stack.m_41783_();
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int stoneCounter = this.m_8105_(stack) - remainingUseTicks;
            if (stoneCounter >= 30) {
                tags.m_128379_("lavalight", false);
                if (!world.m_5776_()) {
                    float strength = BlackstoneGolemArm.getStoneStrength(stoneCounter);
                    stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(p.m_7655_()));
                    ThrownRockEntity thrownRockEntity = new ThrownRockEntity(world, (LivingEntity)playerEntity);
                    thrownRockEntity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, strength * 1.2f, 1.0f);
                    world.m_7967_((Entity)thrownRockEntity);
                    world.m_6269_((Player)null, (Entity)thrownRockEntity, SoundInit.ROCK_THROW_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player = (Player)entity;
        CompoundTag tags = stack.m_41783_();
        MobEffectInstance slowness = new MobEffectInstance(MobEffect.m_19453_((int)2), 9, 0, false, false, false);
        if (selected && !world.m_5776_()) {
            player.m_7292_(slowness);
        }
        if (world.m_5776_() && tags != null) {
            if (player.m_21212_() < 71970 && player.m_21212_() != 0 && player.m_6844_(player.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND) == stack) {
                tags.m_128379_("lavalight", true);
            }
            if (tags.m_128471_("lavalight") && player.m_6844_(player.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND) != stack) {
                tags.m_128379_("lavalight", false);
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return ingredient.m_41720_() == Items.f_42419_;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Vec3 vec3d_1 = attacker.m_20252_(1.0f);
        double x_vector = vec3d_1.f_82479_ / 2.0;
        double z_vector = vec3d_1.f_82481_ / 2.0;
        stack.m_41622_(1, attacker, p -> p.m_21190_(p.m_7655_()));
        target.m_5997_(x_vector, 0.45, z_vector);
        return true;
    }

    public static float getStoneStrength(int useTicks) {
        float f = (float)useTicks / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

